% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bayes-flowClust.R
\name{prior_flowclust}
\alias{prior_flowclust}
\alias{prior_flowClust}
\title{Elicits data-driven priors from a flowSet object for specified channels}
\usage{
prior_flowclust(
  flow_set,
  channels,
  prior_method = c("kmeans"),
  K = 2,
  nu0 = 4,
  w0 = c(10, 10),
  shrink = 1e-06,
  ...
)
}
\arguments{
\item{flow_set}{a \code{flowSet} object}

\item{channels}{a character vector containing the channels in the
\code{flowSet} from which we elicit the prior parameters for the Student's t
mixture}

\item{prior_method}{the method to elicit the prior parameters}

\item{K}{the number of mixture components to identify}

\item{nu0}{prior degrees of freedom of the Student's t mixture components.}

\item{w0}{the number of prior pseudocounts of the Student's t mixture components. (only the first element is used and the rest is ignored at the moment)}

\item{shrink}{the amount of eigenvalue shrinkage to add in the case the prior
covariance matrices are singular. See details.}

\item{...}{Additional arguments passed to the prior elicitation method selected}
}
\value{
list of the necessary prior parameters
}
\description{
We elicit data-driven prior parameters from a \code{flowSet} object for
specified channels. For each sample in the \code{flowSet} object, we apply the
given \code{prior_method} to elicit the priors parameters.
}
\details{
Currently, we have implemented only two methods. In the case that one channel
is given, we use the kernel-density estimator (KDE) approach for each sample
to obtain \code{K} peaks from which we elicit prior parameters. Otherwise,
if more than one channel is specified, we apply K-Means to each of the samples
in the \code{flowSet} and aggregate the clusters to elicit the prior
parameters.

In the rare case that a prior covariance matrix is singular, we shrink the
eigenvalues of the matrix slightly to ensure that it is positive definite. For
instance, if the \code{flow_set} has two samples, this case can occur. The
amount of shrinkage is controlled in \code{shrink}.
}
\examples{
\dontrun{
library(flowCore)
data(GvHD)
prior_flowclust(GvHD[1:3], c("FSC-H", "SSC-H"))
}
}
