context("gs_remove_gating_method")

gs1 <- gs_copy_tree_only(gs)
gs2 <- gs_copy_tree_only(gs)

test_that("gs_remove_gating_method testing", {
  snapshot_pre <- gs_get_pop_paths(gs)
  gs_add_gating_method(gs, alias = "*", pop = "+/-", parent = "/not debris", dims = "CD4", gating_method = "mindensity")
  snapshot_1 <- gs_get_pop_paths(gs)
  gs_add_gating_method(gs, alias = "test_gate", parent = "/not debris/singlets", dims = "CD8,CD4", pop = "+-", gating_method = "mindensity")
  snapshot_2 <- gs_get_pop_paths(gs)
  gs_add_gating_method(gs, alias = "*", pop = "+/-", parent = "/not debris/singlets/CD3+/DNT", dims = "CCR7", 
          gating_method = "gate_quantile", gating_args = "probs = 0.95")
  snapshot_3 <- gs_get_pop_paths(gs)
  gs_remove_gating_method(gs)
  expect_equal(gs_get_pop_paths(gs), snapshot_2)
  gs_remove_gating_method(gs)
  expect_equal(gs_get_pop_paths(gs), snapshot_1)
  gs_remove_gating_method(gs)
  expect_equal(gs_get_pop_paths(gs), snapshot_pre)
  expect_error(gs_remove_gating_method(gs))
  gs_add_gating_method(gs, alias = "*", pop = "+/-", parent = "/not debris", dims = "CD4", gating_method = "mindensity")
  gs_add_gating_method(gs, alias = "test_gate", parent = "/not debris/singlets", dims = "CD8,CD4", pop = "+-", gating_method = "mindensity")
  gs_add_gating_method(gs, alias = "*", pop = "+/-", parent = "/not debris/singlets/CD3+/DNT", dims = "CCR7", 
          gating_method = "gate_quantile", gating_args = "probs = 0.98")
  expect_equal(gs_get_pop_paths(gs), snapshot_3)
  gs_remove_gating_method(gs)
  gs_remove_gating_method(gs)
  gs_remove_gating_method(gs)

  # Just to prevent GatingSetList constructor from protesting overlapping samples
  sampleNames(gs2) <- "CytoTrol_Cytotrol_2.fcs"
  gslist <- GatingSetList(list(gs1, gs2))

  expect_equal(gs_get_pop_paths(gslist[[1]]), snapshot_pre)
  gs_add_gating_method(gslist, alias = "*", pop = "+/-", parent = "/not debris", dims = "CD4", gating_method = "mindensity")
  expect_equal(gs_get_pop_paths(gslist[[1]]), snapshot_1)
  gs_add_gating_method(gslist, alias = "test_gate", parent = "/not debris/singlets", dims = "CD8,CD4", pop = "+-", gating_method = "mindensity")
  expect_equal(gs_get_pop_paths(gslist[[1]]), snapshot_2)
  gs_add_gating_method(gslist, alias = "*", pop = "+/-", parent = "/not debris/singlets/CD3+/DNT", dims = "CCR7", 
          gating_method = "gate_quantile", gating_args = "probs = 0.95")
  expect_equal(gs_get_pop_paths(gslist[[1]]), snapshot_3)
  gs_remove_gating_method(gslist)
  expect_equal(gs_get_pop_paths(gslist[[2]]), snapshot_2)
  gs_remove_gating_method(gslist)
  expect_equal(gs_get_pop_paths(gslist[[2]]), snapshot_1)
  gs_remove_gating_method(gslist)
  expect_equal(gs_get_pop_paths(gslist[[2]]), snapshot_pre)
  expect_error(gs_remove_gating_method(gslist))
  gs_add_gating_method(gslist, alias = "*", pop = "+/-", parent = "/not debris", dims = "CD4", gating_method = "mindensity")
  gs_add_gating_method(gslist, alias = "test_gate", parent = "/not debris/singlets", dims = "CD8,CD4", pop = "+-", gating_method = "mindensity")
  gs_add_gating_method(gslist, alias = "*", pop = "+/-", parent = "/not debris/singlets/CD3+/DNT", dims = "CCR7", 
          gating_method = "gate_quantile", gating_args = "probs = 0.98")
  expect_equal(gs_get_pop_paths(gslist[[2]]), snapshot_3)
  gs_remove_gating_method(gslist)
  gs_remove_gating_method(gslist)
  gs_remove_gating_method(gslist)
  
  # Repeat test for one of the component GatingSets to make sure it carried the adds and removals correctly
  expect_equal(gs_get_pop_paths(gs2), snapshot_pre)
  gs_add_gating_method(gs2, alias = "*", pop = "+/-", parent = "/not debris", dims = "CD4", gating_method = "mindensity")
  expect_equal(gs_get_pop_paths(gs2), snapshot_1)
  gs_add_gating_method(gs2, alias = "test_gate", parent = "/not debris/singlets", dims = "CD8,CD4", pop = "+-", gating_method = "mindensity")
  expect_equal(gs_get_pop_paths(gs2), snapshot_2)
  gs_add_gating_method(gs2, alias = "*", pop = "+/-", parent = "/not debris/singlets/CD3+/DNT", dims = "CCR7", 
          gating_method = "gate_quantile", gating_args = "probs = 0.95")
  expect_equal(gs_get_pop_paths(gs2), snapshot_3)
  gs_remove_gating_method(gs2)
  expect_equal(gs_get_pop_paths(gs2), snapshot_2)
  gs_remove_gating_method(gs2)
  expect_equal(gs_get_pop_paths(gs2), snapshot_1)
  gs_remove_gating_method(gs2)
  expect_equal(gs_get_pop_paths(gs2), snapshot_pre)
  expect_error(gs_remove_gating_method(gs2))
  gs_add_gating_method(gs2, alias = "*", pop = "+/-", parent = "/not debris", dims = "CD4", gating_method = "mindensity")
  gs_add_gating_method(gs2, alias = "test_gate", parent = "/not debris/singlets", dims = "CD8,CD4", pop = "+-", gating_method = "mindensity")
  gs_add_gating_method(gs2, alias = "*", pop = "+/-", parent = "/not debris/singlets/CD3+/DNT", dims = "CCR7", 
          gating_method = "gate_quantile", gating_args = "probs = 0.98")
  expect_equal(gs_get_pop_paths(gs2), snapshot_3)
  gs_remove_gating_method(gs2)
  gs_remove_gating_method(gs2)
  gs_remove_gating_method(gs2)
  
  # Repeat test for loaded GatingSet with same guid to make sure starting from blank slate
  # after removals
  gs <- load_gs(list.files(dataDir, pattern = "gs_manual",full = TRUE))
  expect_equal(gs_get_pop_paths(gs), snapshot_pre)
  gs_add_gating_method(gs, alias = "*", pop = "+/-", parent = "/not debris", dims = "CD4", gating_method = "mindensity")
  expect_equal(gs_get_pop_paths(gs), snapshot_1)
  gs_add_gating_method(gs, alias = "test_gate", parent = "/not debris/singlets", dims = "CD8,CD4", pop = "+-", gating_method = "mindensity")
  expect_equal(gs_get_pop_paths(gs), snapshot_2)
  gs_add_gating_method(gs, alias = "*", pop = "+/-", parent = "/not debris/singlets/CD3+/DNT", dims = "CCR7", 
          gating_method = "gate_quantile", gating_args = "probs = 0.95")
  expect_equal(gs_get_pop_paths(gs), snapshot_3)
  gs_remove_gating_method(gs)
  expect_equal(gs_get_pop_paths(gs), snapshot_2)
  gs_remove_gating_method(gs)
  expect_equal(gs_get_pop_paths(gs), snapshot_1)
  gs_remove_gating_method(gs)
  expect_equal(gs_get_pop_paths(gs), snapshot_pre)
  gs_add_gating_method(gs, alias = "*", pop = "+/-", parent = "/not debris", dims = "CD4", gating_method = "mindensity")
  gs_add_gating_method(gs, alias = "test_gate", parent = "/not debris/singlets", dims = "CD8,CD4", pop = "+-", gating_method = "mindensity")
  gs_add_gating_method(gs, alias = "*", pop = "+/-", parent = "/not debris/singlets/CD3+/DNT", dims = "CCR7", 
          gating_method = "gate_quantile", gating_args = "probs = 0.98")
  expect_equal(gs_get_pop_paths(gs), snapshot_3)

# Repeat test for loaded GatingSet with same guid to make sure starting from blank slate
# after gs_add_gating_method_init()
  gs_add_gating_method_init()
  gs <- load_gs(list.files(dataDir, pattern = "gs_manual",full = TRUE))
  expect_equal(gs_get_pop_paths(gs), snapshot_pre)
  gs_add_gating_method(gs, alias = "*", pop = "+/-", parent = "/not debris", dims = "CD4", gating_method = "mindensity")
  expect_equal(gs_get_pop_paths(gs), snapshot_1)
  gs_add_gating_method(gs, alias = "test_gate", parent = "/not debris/singlets", dims = "CD8,CD4", pop = "+-", gating_method = "mindensity")
  expect_equal(gs_get_pop_paths(gs), snapshot_2)
  gs_add_gating_method(gs, alias = "*", pop = "+/-", parent = "/not debris/singlets/CD3+/DNT", dims = "CCR7", 
          gating_method = "gate_quantile", gating_args = "probs = 0.95")
  expect_equal(gs_get_pop_paths(gs), snapshot_3)
  gs_remove_gating_method(gs)
  expect_equal(gs_get_pop_paths(gs), snapshot_2)
  gs_remove_gating_method(gs)
  expect_equal(gs_get_pop_paths(gs), snapshot_1)
  gs_remove_gating_method(gs)
  expect_equal(gs_get_pop_paths(gs), snapshot_pre)
  expect_error(gs_remove_gating_method(gs))
  gs_add_gating_method(gs, alias = "*", pop = "+/-", parent = "/not debris", dims = "CD4", gating_method = "mindensity")
  gs_add_gating_method(gs, alias = "test_gate", parent = "/not debris/singlets", dims = "CD8,CD4", pop = "+-", gating_method = "mindensity")
  gs_add_gating_method(gs, alias = "*", pop = "+/-", parent = "/not debris/singlets/CD3+/DNT", dims = "CCR7", 
          gating_method = "gate_quantile", gating_args = "probs = 0.98")
  expect_equal(gs_get_pop_paths(gs), snapshot_3)
})
