% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods_peakPantheRAnnotation.R
\docType{methods}
\name{EICs,peakPantheRAnnotation-method}
\alias{EICs,peakPantheRAnnotation-method}
\alias{EICs}
\title{EICs accessor}
\usage{
\S4method{EICs}{peakPantheRAnnotation}(object, aggregationFunction)
}
\arguments{
\item{object}{peakPantheRAnnotation}

\item{aggregationFunction}{(str) Function to use in order to aggregate
intensities across mz in each scan. One of \code{sum}, \code{max},
\code{min}, \code{mean}}
}
\value{
(float) Extracted Ion Chromatogram aggregated across mz in each scan
}
\description{
EICs accessor
}
\examples{
if(requireNamespace('faahKO')){
## Initialise a peakPantheRAnnotation object with 3 samples and 2 targeted
## compounds

# Paths to spectra files
library(faahKO)
spectraPaths <- c(system.file('cdf/KO/ko15.CDF', package = 'faahKO'),
                    system.file('cdf/KO/ko16.CDF', package = 'faahKO'),
                    system.file('cdf/KO/ko18.CDF', package = 'faahKO'))

# targetFeatTable
targetFeatTable <- data.frame(matrix(vector(), 2, 8, dimnames=list(c(),
                    c('cpdID','cpdName','rtMin','rt','rtMax','mzMin','mz',
                    'mzMax'))), stringsAsFactors=FALSE)
targetFeatTable[1,] <- c('ID-1', 'Cpd 1', 3310., 3344.888, 3390., 522.194778,
                        522.2, 522.205222)
targetFeatTable[2,] <- c('ID-2', 'Cpd 2', 3280., 3385.577, 3440., 496.195038,
                        496.2, 496.204962)
targetFeatTable[,c(3:8)] <- vapply(targetFeatTable[,c(3:8)], as.numeric,
                                    FUN.VALUE=numeric(2))

annotation <- peakPantheRAnnotation(spectraPaths=spectraPaths,
                                    targetFeatTable=targetFeatTable)

## default values without annotation
EICs(annotation)
# [[1]]
# list()
# [[2]]
# list()
# [[3]]
# list()
}
}
