% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grid2sf.R
\name{grid2df}
\alias{grid2df}
\title{Convert x,y nodes to data.frame of polygons}
\usage{
grid2df(
  spe,
  x = spe@metadata$grid_density$node_x,
  y = spe@metadata$grid_density$node_y,
  reverseY = FALSE,
  ...
)
}
\arguments{
\item{spe}{A SpatialExperiment object with grid density calculated}

\item{x}{vector of x nodes of the polygons}

\item{y}{vector of y nodes of the polygons}

\item{reverseY}{Reverse y coordinates. Can be numeric to specify the value to
subtract y coordinates from (reverseY - y coords).}

\item{...}{other elements to be stored as columns of the data.frame. Each one
must be a vector same length as x.}
}
\value{
data.frame with X, Y, and L2. Points with the same L2 belong to the
same polygons
}
\description{
Convert x,y nodes to data.frame of polygons
}
\details{
Basically grid2sf() but returns a data.frame for plotting with geom_polygon(),
which allows for scale_*_transform(), unlike geom_sf().

Column names are kept similar to sf::st_coordinates
}
