% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/impute_missing_abundance.R
\docType{methods}
\name{impute_missing_abundance}
\alias{impute_missing_abundance}
\alias{impute_missing_abundance,SummarizedExperiment-method}
\alias{impute_missing_abundance,RangedSummarizedExperiment-method}
\title{impute transcript abundance if missing from sample-transcript pairs}
\usage{
impute_missing_abundance(
  .data,
  .formula,
  suffix = "",
  force_scaling = FALSE,
  ...,
  abundance = assayNames(.data)[1],
  .abundance = NULL
)

\S4method{impute_missing_abundance}{SummarizedExperiment}(
  .data,
  .formula,
  suffix = "",
  force_scaling = FALSE,
  ...,
  abundance = assayNames(.data)[1],
  .abundance = NULL
)

\S4method{impute_missing_abundance}{RangedSummarizedExperiment}(
  .data,
  .formula,
  suffix = "",
  force_scaling = FALSE,
  ...,
  abundance = assayNames(.data)[1],
  .abundance = NULL
)
}
\arguments{
\item{.data}{A `tbl` (with at least three columns for sample, feature and transcript abundance) or `SummarizedExperiment` (more convenient if abstracted to tibble with library(tidySummarizedExperiment))}

\item{.formula}{A formula with no response variable, representing the desired linear model where the first covariate is the factor of interest and the second covariate is the unwanted variation (of the kind ~ factor_of_interest + batch)}

\item{suffix}{A character string. This is added to the imputed count column names. If empty the count column are overwritten}

\item{force_scaling}{A boolean. In case a abundance-containing column is not scaled (columns with _scale suffix), setting force_scaling = TRUE will result in a scaling by library size, to compensating for a possible difference in sequencing depth.}

\item{...}{Further arguments.}

\item{abundance}{The name of the transcript/gene abundance column (character, preferred)}

\item{.abundance}{DEPRECATED. The name of the transcript/gene abundance column (symbolic, for backward compatibility)}
}
\value{
A consistent object (to the input) non-sparse abundance

A `SummarizedExperiment` object

A `SummarizedExperiment` object
}
\description{
impute_missing_abundance() takes as input A `tbl` (with at least three columns for sample, feature and transcript abundance) or `SummarizedExperiment` (more convenient if abstracted to tibble with library(tidySummarizedExperiment)) and returns a consistent object (to the input) with additional sample-transcript pairs with imputed transcript abundance.
}
\details{
`r lifecycle::badge("maturing")`

This function imputes the abundance of missing sample-transcript pair using the median of the sample group defined by the formula
}
\examples{
## Load airway dataset for examples

  data('airway', package = 'airway')
  # Ensure a 'condition' column exists for examples expecting it

    SummarizedExperiment::colData(airway)$condition <- SummarizedExperiment::colData(airway)$dex


library(airway)
data(airway)
airway <- airway[1:100, 1:5]

airway |>
  impute_missing_abundance(.formula = ~ dex)

}
\references{
Mangiola, S., Molania, R., Dong, R., Doyle, M. A., & Papenfuss, A. T. (2021). tidybulk: an R tidy framework for modular transcriptomic data analysis. Genome Biology, 22(1), 42. doi:10.1186/s13059-020-02233-7
}
