% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RunClustering.R
\name{determine_fuzz}
\alias{determine_fuzz}
\title{Determine individual fuzzifier values}
\usage{
determine_fuzz(dims, NClust, Sds = 1)
}
\arguments{
\item{dims}{vector of two integers containing the dimensions of the data 
matrix for the clustering}

\item{NClust}{Number of cluster for running vsclust on (does no influence the 
calculation of `mm`)}

\item{Sds}{individual standard deviations, set to 1 if not available}
}
\value{
list of `m`: individual fuzzifiers, `mm`: standard fuzzifier for fcm 
clustering when not using vsclust algorithm
}
\description{
This function calculated the values of the fuzzifier from a) the dimensions
of the considered data set and b)
from the individual feature standard deviations.
}
\examples{
# Generate some random data
data <- matrix(rnorm(seq_len(1000)), nrow=100)
# Estimate fuzzifiers
fuzz_out <- determine_fuzz(dim(data), 1)
# Run clustering
clres <- vsclust_algorithm(data, centers=5, m=fuzz_out$mm)
}
\references{
Schwaemmle V, Jensen ON. VSClust: feature-based variance-sensitive clustering 
of omics data. Bioinformatics. 2018 Sep 1;34(17):2965-2972. doi: 
10.1093/bioinformatics/bty224. PMID: 29635359.

Schwaemmle V, Hagensen CE. A Tutorial for Variance-Sensitive Clustering and 
the Quantitative Analysis of Protein Complexes. Methods Mol Biol. 
2021;2228:433-451. doi: 10.1007/978-1-0716-1024-4_30. PMID: 33950508.

Schwaemmle V, Jensen ON. A simple and fast method to determine the parameters 
for fuzzy c-means cluster analysis. Bioinformatics. 2010 Nov 15;
26(22):2841-8. doi: 10.1093/bioinformatics/btq534. Epub 2010 Sep 29. 
PMID: 20880957.
}
