% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EvaluateClustering.R
\name{cvalidate.xiebeni}
\alias{cvalidate.xiebeni}
\title{Xie Beni Index of clustering object}
\usage{
cvalidate.xiebeni(clres, m)
}
\arguments{
\item{clres}{Output from clustering. Either fclust object or list containing 
the objects for `membership` and cluster `centers`}

\item{m}{Fuzzifier value}
}
\value{
Xie Beni index
}
\description{
Calculate the Xie Beni index for validity of the cluster number in clustering 
results from running fuzzy c-means or vsclust
original publication:
}
\examples{
# Generate some random data
data <- matrix(rnorm(seq_len(1000)), nrow=100)
# Run clustering
clres <- vsclust_algorithm(data, centers=5, m=1.5)
# Calculate Xie-Beni index from results
cvalidate.xiebeni(clres, 1.5)
}
\references{
Xie X.L., Beni G. (1991). A validity measure for fuzzy 
clustering, IEEE Transactions on Pattern Analysis and Machine Intelligence, 
13, 841-847.
}
