% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/do_groupChromPeaks-functions.R
\name{do_groupPeaks_mzClust}
\alias{do_groupPeaks_mzClust}
\title{Core API function for peak grouping using mzClust}
\usage{
do_groupPeaks_mzClust(
  peaks,
  sampleGroups,
  ppm = 20,
  absMz = 0,
  minFraction = 0.5,
  minSamples = 1
)
}
\arguments{
\item{peaks}{A \code{matrix} or \code{data.frame} with the mz values and
retention times of the identified chromatographic peaks in all samples
of an experiment. Required columns are \code{"mz"}, \code{"rt"} and
\code{"sample"}. The latter should contain \code{numeric} values representing
the index of the sample in which the peak was found.}

\item{sampleGroups}{For \code{PeakDensityParam}: A vector of the same length than
samples defining the sample group assignments (i.e. which samples
belong to which sample group). This parameter is mandatory for
\code{PeakDensityParam} and has to be defined also if there is no sample
grouping in the experiment (in which case all samples should be
assigned to the same group). Samples for which a \code{NA} is provided will
not be considered in the feature definitions step. Providing \code{NA} for
all blanks in an experiment will for example avoid features to be
defined for signals (chrom peaks) present only in blank samples.}

\item{ppm}{For \code{MzClustParam}: \code{numeric(1)} representing the relative m/z
error for the clustering/grouping (in parts per million).
For \code{PeakDensityParam}: \code{numeric(1)} to define m/z-dependent, increasing
m/z bin sizes. If \code{ppm = 0} (the default) m/z bins are defined by the
sequence of values from the smallest to the larges m/z value with a
constant bin size of \code{binSize}. For \code{ppm} > 0 the size of each bin is
increased in addition by the \code{ppm} of the (upper) m/z boundary of the
bin. The maximal bin size (used for the largest m/z values) would then
be \code{binSize} plus \code{ppm} parts-per-million of the largest m/z value of
all peaks in the data set.}

\item{absMz}{For \code{NearestPeaksParam} and \code{MzClustParam}: \code{numeric(1)}
maximum tolerated distance for m/z values.}

\item{minFraction}{For \code{PeakDensityParam}: \code{numeric(1)} defining the minimum
fraction of samples in at least one sample group in which the peaks
have to be present to be considered as a peak group (feature).}

\item{minSamples}{For \code{PeakDensityParam}: \code{numeric(1)} with the minimum
number of samples in at least one sample group in which the peaks have
to be detected to be considered a peak group (feature).}
}
\value{
A \code{list} with elements \code{"featureDefinitions"} and
\code{"peakIndex"}. \code{"featureDefinitions"} is a \code{matrix}, each row
representing an (mz-rt) feature (i.e. peak group) with columns:
\itemize{
\item \code{"mzmed"}: median of the peaks' apex mz values.
\item \code{"mzmin"}: smallest mz value of all peaks' apex within the feature.
\item \code{"mzmax"}: largest mz value of all peaks' apex within the feature.
\item \code{"rtmed"}: always \code{-1}.
\item \code{"rtmin"}: always \code{-1}.
\item \code{"rtmax"}: always \code{-1}.
\item \code{"npeaks"}: the total number of peaks assigned to the feature. Note that
this number can be larger than the total number of samples, since
multiple peaks from the same sample could be assigned to a group.
}

\code{"peakIndex"} is a \code{list} with the indices of all peaks in a peak group in
the \code{peaks} input matrix.
}
\description{
The \code{do_groupPeaks_mzClust} function performs high resolution
correspondence on single spectra samples.
}
\references{
Saira A. Kazmi, Samiran Ghosh, Dong-Guk Shin, Dennis W. Hill
and David F. Grant\cr \emph{Alignment of high resolution mass spectra:
development of a heuristic approach for metabolomics}.\cr Metabolomics,
Vol. 2, No. 2, 75-83 (2006)
}
\seealso{
Other core peak grouping algorithms: 
\code{\link{do_groupChromPeaks_density}()},
\code{\link{do_groupChromPeaks_nearest}()}
}
\concept{core peak grouping algorithms}
