% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-group-features.R
\name{feature-grouping}
\alias{feature-grouping}
\alias{featureGroups,XcmsResult-method}
\alias{featureGroups<-,XcmsResult-method}
\title{Compounding of LC-MS features}
\usage{
\S4method{featureGroups}{XcmsResult}(object)

\S4method{featureGroups}{XcmsResult}(object) <- value
}
\arguments{
\item{object}{an \code{\link[=XcmsExperiment]{XcmsExperiment()}} or \code{\link[=XCMSnExp]{XCMSnExp()}} object with LC-MS
pre-processing results.}

\item{value}{for \verb{featureGroups<-}: replacement for the feature groups in
\code{object}. Has to be of length 1 or length equal to the number of features
in \code{object}.}
}
\description{
Feature \emph{compounding} aims at identifying and grouping LC-MS features
representing different ions or adducts (including isotopes) of the same
originating compound.
The \href{https://bioconductor.org/packages/MsFeatures}{MsFeatures} package
provides a general framework and functionality to group features based on
different properties. The \code{groupFeatures} methods for \code{\link[=XcmsExperiment]{XcmsExperiment()}} or
\linkS4class{XCMSnExp} objects implemented in \code{xcms} extend these to enable
the \emph{compounding} of LC-MS data considering also e.g. feature peak shaped.
Note that these functions simply define feature groups but don't
actually \emph{aggregate} or combine the features.

See \code{\link[MsFeatures:groupFeatures]{MsFeatures::groupFeatures()}} for an overview on the general feature
grouping concept as well as details on the individual settings and
parameters.

The available options for \code{groupFeatures} on \code{xcms} preprocessing results
(i.e. on \code{XcmsExperiment} or \code{XCMSnExp} objects after correspondence
analysis with \code{\link[=groupChromPeaks]{groupChromPeaks()}}) are:
\itemize{
\item Grouping by similar retention times: \code{\link[=groupFeatures-similar-rtime]{groupFeatures-similar-rtime()}}.
\item Grouping by similar feature values across samples:
\code{\link[MsFeatures:groupFeatures-similar-abundance]{MsFeatures::AbundanceSimilarityParam()}}.
\item Grouping by similar peak shape of extracted ion chromatograms:
\code{\link[=EicSimilarityParam]{EicSimilarityParam()}}.
}

An ideal workflow grouping features should sequentially perform the above
methods (in the listed order).

Compounded feature groups can be accessed with the \code{featureGroups} function.
}
\seealso{
\code{\link[=plotFeatureGroups]{plotFeatureGroups()}} for visualization of grouped features.
}
\author{
Johannes Rainer, Mar Garcia-Aloy, Vinicius Veri Hernandes
}
