% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/XcmsExperiment.R,
%   R/methods-XCMSnExp.R
\name{reconstructChromPeakSpectra}
\alias{reconstructChromPeakSpectra}
\alias{reconstructChromPeakSpectra,XcmsExperiment-method}
\alias{reconstructChromPeakSpectra,XCMSnExp-method}
\title{Data independent acquisition (DIA): reconstruct MS2 spectra}
\usage{
reconstructChromPeakSpectra(object, ...)

\S4method{reconstructChromPeakSpectra}{XcmsExperiment}(
  object,
  expandRt = 0,
  diffRt = 2,
  minCor = 0.8,
  intensity = "maxo",
  peakId = rownames(chromPeaks(object, msLevel = 1L)),
  BPPARAM = bpparam()
)

\S4method{reconstructChromPeakSpectra}{XCMSnExp}(
  object,
  expandRt = 0,
  diffRt = 2,
  minCor = 0.8,
  intensity = "maxo",
  peakId = rownames(chromPeaks(object, msLevel = 1L)),
  BPPARAM = bpparam(),
  return.type = c("Spectra", "MSpectra")
)
}
\arguments{
\item{object}{\code{XCMSnExp} with identified chromatographic peaks.}

\item{...}{ignored.}

\item{expandRt}{\code{numeric(1)} allowing to expand the retention time range
for extracted ion chromatograms by a constant value (for the peak
shape correlation). Defaults to \code{expandRt = 0} hence correlates only
the signal included in the identified chromatographic peaks.}

\item{diffRt}{\code{numeric(1)} defining the maximal allowed difference between
the retention time of the chromatographic peak (apex) and the retention
times of MS2 chromatographic peaks (apex) to consider them as
representing candidate fragments of the original ion.}

\item{minCor}{\code{numeric(1)} defining the minimal required correlation
coefficient for MS2 chromatographic peaks to be considered for MS2
spectrum reconstruction.}

\item{intensity}{\code{character(1)} defining the column in the \code{chromPeaks}
matrix that should be used for the intensities of the reconstructed
spectra's peaks. The same value from the MS1 chromatographic peaks will
be used as \code{precursorIntensity} of the resulting spectra.}

\item{peakId}{optional \code{character} vector with peak IDs (i.e. rownames of
\code{chromPeaks}) of MS1 peaks for which MS2 spectra should be reconstructed.
By default they are reconstructed for all MS1 chromatographic peaks.}

\item{BPPARAM}{parallel processing setup. See \code{\link[BiocParallel:register]{BiocParallel::bpparam()}}
for more information.}

\item{return.type}{\code{character(1)} defining the type of the returned object.
Only \code{return.type = "Spectra"} is supported, \code{return.type = "MSpectra"}
is deprecated.}
}
\value{
\itemize{
\item \code{\link[Spectra:Spectra]{Spectra::Spectra()}} object (defined in the \code{Spectra} package) with the
reconstructed MS2 spectra for all MS1 peaks in \code{object}. Contains
empty spectra (i.e. without m/z and intensity values) for MS1 peaks for
which reconstruction was not possible (either no MS2 signal was recorded
or the correlation of the MS2 chromatographic peaks with the MS1
chromatographic peak was below threshold \code{minCor}. Spectra variables
\code{"ms2_peak_id"} and \code{"ms2_peak_cor"} (of type \code{\link[IRanges:AtomicList-class]{IRanges::CharacterList()}}
and \code{\link[IRanges:AtomicList-class]{IRanges::NumericList()}} with length equal to the number of peaks per
reconstructed MS2 spectrum) providing the IDs and the correlation of the
MS2 chromatographic peaks from which the MS2 spectrum was reconstructed.
As retention time the median retention times of all MS2 chromatographic
peaks used for the spectrum reconstruction is reported. The MS1
chromatographic peak intensity is reported as the reconstructed
spectrum's \code{precursorIntensity} value (see parameter \code{intensity} above).
}
}
\description{
\emph{Reconstructs} MS2 spectra for each MS1 chromatographic peak (if possible)
for data independent acquisition (DIA) data (such as SWATH). See the
\emph{LC-MS/MS analysis} vignette for more details and examples.
}
\details{
In detail, the function performs for each MS1 chromatographic peak:
\itemize{
\item Identify all MS2 chromatographic peaks from the isolation window
containing the m/z of the ion (i.e. the MS1 chromatographic peak) with
approximately the same retention time than the MS1 peak (accepted rt shift
can be specified with the \code{diffRt} parameter).
\item Correlate the peak shapes of the candidate MS2 chromatographic peaks with
the peak shape of the MS1 peak retaining only MS2 chromatographic peaks
for which the correlation is \verb{> minCor}.
\item Reconstruct the MS2 spectrum using the m/z of all above selected MS2
chromatographic peaks and their intensity (either \code{"maxo"} or \code{"into"}).
Each MS2 chromatographic peak selected for an MS1 peak will thus represent
one \strong{mass peak} in the reconstructed spectrum.
}

The resulting \code{\link[Spectra:Spectra]{Spectra::Spectra()}} object provides also the peak IDs of
the MS2 chromatographic peaks for each spectrum as well as their
correlation value with spectra variables \emph{ms2_peak_id} and \emph{ms2_peak_cor}.
}
\seealso{
\code{\link[=findChromPeaksIsolationWindow]{findChromPeaksIsolationWindow()}} for the function to perform MS2
peak detection in DIA isolation windows and for examples.
}
\author{
Johannes Rainer, Michael Witting
}
