datacache <- new.env(hash=TRUE, parent=emptyenv())

org.Gg.eg <- function() showQCData("org.Gg.eg", datacache)
org.Gg.eg_dbconn <- function() dbconn(datacache)
org.Gg.eg_dbfile <- function() dbfile(datacache)
org.Gg.eg_dbschema <- function(file="", show.indices=FALSE) dbschema(datacache, file=file, show.indices=show.indices)
org.Gg.eg_dbInfo <- function() dbInfo(datacache)

org.Gg.egORGANISM <- "Gallus gallus"

.onLoad <- function(libname, pkgname)
{
    ## Connect to the SQLite DB
    dbfile <- system.file("extdata", "org.Gg.eg.sqlite", package=pkgname, lib.loc=libname)
    assign("dbfile", dbfile, envir=datacache)
    dbconn <- dbFileConnect(dbfile)
    assign("dbconn", dbconn, envir=datacache)

    ## Create the OrgDb object
    sPkgname <- sub(".db$","",pkgname)
    txdb <- loadDb(system.file("extdata", paste(sPkgname,
      ".sqlite",sep=""), package=pkgname, lib.loc=libname),
                   packageName=pkgname)    
    dbNewname <- AnnotationDbi:::dbObjectName(pkgname,"OrgDb")
    ns <- asNamespace(pkgname)
    assign(dbNewname, txdb, envir=ns)
    namespaceExport(ns, dbNewname)
        
    ## Create the AnnObj instances
    ann_objs <- createAnnObjs.SchemaChoice("CHICKEN_DB", "org.Gg.eg", "Chicken", dbconn, datacache)
    mergeToNamespaceAndExport(ann_objs, pkgname)
    packageStartupMessage(AnnotationDbi:::annoStartupMessages("org.Gg.eg"))
}

.onUnload <- function(libpath)
{
    dbFileDisconnect(org.Gg.eg_dbconn())
}

