datacache <- new.env(hash=TRUE, parent=emptyenv())

org.Sc.sgd <- function() showQCData("org.Sc.sgd", datacache)
org.Sc.sgd_dbconn <- function() dbconn(datacache)
org.Sc.sgd_dbfile <- function() dbfile(datacache)
org.Sc.sgd_dbschema <- function(file="", show.indices=FALSE) dbschema(datacache, file=file, show.indices=show.indices)
org.Sc.sgd_dbInfo <- function() dbInfo(datacache)

org.Sc.sgdORGANISM <- "Saccharomyces cerevisiae"

.onLoad <- function(libname, pkgname)
{
    ## Connect to the SQLite DB
    dbfile <- system.file("extdata", "org.Sc.sgd.sqlite", package=pkgname, lib.loc=libname)
    assign("dbfile", dbfile, envir=datacache)
    dbconn <- dbFileConnect(dbfile)
    assign("dbconn", dbconn, envir=datacache)

    ## Create the OrgDb object
    sPkgname <- sub(".db$","",pkgname)
    txdb <- loadDb(system.file("extdata", paste(sPkgname,
      ".sqlite",sep=""), package=pkgname, lib.loc=libname),
                   packageName=pkgname)    
    dbNewname <- AnnotationDbi:::dbObjectName(pkgname,"OrgDb")
    ns <- asNamespace(pkgname)
    assign(dbNewname, txdb, envir=ns)
    namespaceExport(ns, dbNewname)
        
    ## Create the AnnObj instances
    ann_objs <- createAnnObjs.SchemaChoice("YEAST_DB", "org.Sc.sgd", "Yeast", dbconn, datacache)
    mergeToNamespaceAndExport(ann_objs, pkgname)
    packageStartupMessage(AnnotationDbi:::annoStartupMessages("org.Sc.sgd.db"))
}

.onUnload <- function(libpath)
{
    dbFileDisconnect(org.Sc.sgd_dbconn())
}

