## ----setup, include=FALSE-----------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)
library(TFEA.ChIP)

## ----lib-install, message=FALSE, eval=FALSE-----------------------------------
# if (!require("BiocManager", quietly = TRUE))
#     install.packages("BiocManager")
# BiocManager::install("ChIPDBData")

## ----load-lib, message=FALSE, warning=FALSE, cache=FALSE----------------------
library(ChIPDBData)

## ----load-chipdb-eh-----------------------------------------------------------
library(ExperimentHub)

eh <- ExperimentHub()
dbs <- query(eh, "ChIPDBData")
dbs

# Example: Load ENCODE rE2G300d
ChIPDB <- dbs[["EH9854"]]  # IMPORTANT: Assign to 'ChIPDB'

## ----load-chipdb--------------------------------------------------------------
# Load the ENCODE dataset filtered by depth >= 300
ChIPDB <- getChIPDB("ENCODE_rE2G_300depth")

## ----explore-db---------------------------------------------------------------
# List names of the top-level elements
names(ChIPDB)

# Preview the first few Entrez IDs
ChIPDB[[1]][1:5]

# View names of ChIP-seq experiments
names(ChIPDB[[2]])[1:3]

# Show gene indices for the first experiment
ChIPDB[[2]][[1]][1:5]

# Get actual gene IDs from those indices
ChIPDB[[1]][ ChIPDB[[2]][[1]][1:5] ]

## ----eval=TRUE----------------------------------------------------------------
# Load and preprocess differential expression table
data('hypoxia_DESeq')
hypoxia_table <- preprocessInputData(hypoxia_DESeq)

# Define gene sets
Genes.Upreg <- Select_genes(hypoxia_table, min_LFC = 1)
Genes.Control <- Select_genes(hypoxia_table,
  min_pval = 0.5, max_pval = 1,
  min_LFC = -0.25, max_LFC = 0.25
)

# Run TF enrichment
CM_list <- contingency_matrix(Genes.Upreg, Genes.Control)
results <- getCMstats(CM_list)

# Display results
head(results)

## ----session-info-------------------------------------------------------------
sessionInfo()

