## ----setup, include = FALSE---------------------------------------------------
knitr::opts_chunk$set(
    collapse = TRUE,
    comment = "#>",
    crop = NULL,
    message = FALSE
)

## ----eval = FALSE-------------------------------------------------------------
# if(!requireNamespace("BiocManager", quietly = TRUE))
#         install.packages("BiocManager")
# BiocManager::install("ProteinGymR")

## ----message = FALSE----------------------------------------------------------
library(ProteinGymR)
library(tidyr)
library(dplyr)
library(stringr)
library(ggplot2)

## ----import dms---------------------------------------------------------------
dms_data <- dms_substitutions()

## ----view studies-------------------------------------------------------------
head(names(dms_data))

## ----view assay---------------------------------------------------------------
head(dms_data[[1]])

## ----queryEH------------------------------------------------------------------
eh <- ExperimentHub::ExperimentHub()
AnnotationHub::query(eh, "ProteinGymR")

dms_metadata <- eh[["EH9607"]]
names(dms_metadata)

## ----available_models---------------------------------------------------------
available_models()

## ----warning=FALSE, fig.wide = TRUE-------------------------------------------
benchmark_models(metric = "AUC", 
    models = c("GEMME", "CARP_600K", "ESM1b", "VESPA", "ProtGPT2"))

## ----sesh info----------------------------------------------------------------
sessionInfo()

