% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/registration_stats_enrichment.R
\name{registration_stats_enrichment}
\alias{registration_stats_enrichment}
\title{Spatial registration: compute enrichment statistics}
\usage{
registration_stats_enrichment(
  sce_pseudo,
  block_cor,
  covars = NULL,
  var_registration = "registration_variable",
  var_sample_id = "registration_sample_id",
  gene_ensembl = NULL,
  gene_name = NULL
)
}
\arguments{
\item{sce_pseudo}{The output of \code{registration_pseudobulk()}.}

\item{block_cor}{A \code{numeric(1)} computed with \code{registration_block_cor()}.}

\item{covars}{A \code{character()} with names of sample-level covariates.}

\item{var_registration}{A \code{character(1)} specifying the \code{colData(sce_pseudo)}
variable of interest against which will be used for computing the relevant
statistics.}

\item{var_sample_id}{A \code{character(1)} specifying the \code{colData(sce_pseudo)}
variable with the sample ID.}

\item{gene_ensembl}{A \code{character(1)} specifying the \code{rowData(sce_pseudo)}
column with the ENSEMBL gene IDs. This will be used by \code{layer_stat_cor()}.}

\item{gene_name}{A \code{character(1)} specifying the \code{rowData(sce_pseudo)}
column with the gene names (symbols).}
}
\value{
A \code{data.frame()} with the enrichment statistical results. This is
similar to \code{fetch_data("modeling_results")$enrichment}.
}
\description{
This function computes the gene enrichment t-statistics (one group > the
rest). These t-statistics are the ones typically used for spatial
registration with \code{layer_stat_cor()} and related functions.
}
\examples{
example("registration_block_cor", package = "spatialLIBD")
results_enrichment <- registration_stats_enrichment(sce_pseudo,
    block_cor, "age",
    gene_ensembl = "ensembl", gene_name = "gene_name"
)
head(results_enrichment)

## Specifying `block_cor = NaN` then ignores the correlation structure
results_enrichment_nan <- registration_stats_enrichment(sce_pseudo,
    block_cor = NaN, "age",
    gene_ensembl = "ensembl", gene_name = "gene_name"
)
head(results_enrichment_nan)
}
\seealso{
Other spatial registration and statistical modeling functions: 
\code{\link{registration_block_cor}()},
\code{\link{registration_model}()},
\code{\link{registration_pseudobulk}()},
\code{\link{registration_stats_anova}()},
\code{\link{registration_stats_pairwise}()},
\code{\link{registration_wrapper}()}
}
\concept{spatial registration and statistical modeling functions}
