/*
 * Decompiled with CFR 0.152.
 */
package com.gkano.bioinfo.tree;

public class ClusterPoisson {
    private double genomeAbundance;
    private double genomeLength;
    private int lowLimit;
    private int highLimit;

    private ClusterPoisson() {
    }

    public ClusterPoisson(double genomeAbundance, double genomeLength) {
        this.genomeAbundance = genomeAbundance;
        this.genomeLength = genomeLength;
    }

    public double getProbability(int count, ClusterPoisson[] poissons, int myIndex) {
        double probability = this.genomeLength;
        double sum = 0.0;
        for (int i = 0; i < poissons.length; ++i) {
            ClusterPoisson other = poissons[i];
            if (i == myIndex) {
                sum += this.genomeLength;
                continue;
            }
            double lnSum = ClusterPoisson.lnPoissonProbabilitySum(other.genomeAbundance, this.genomeAbundance, count, other.genomeLength);
            double tempSum = Math.exp(lnSum);
            if (Double.isInfinite(tempSum)) {
                return 0.0;
            }
            sum += tempSum;
        }
        return probability / sum;
    }

    public static double lnPoissonProbabilitySum(double a1, double a2, int count, double size) {
        return (double)count * (Math.log(a1) - Math.log(a2)) + (a2 - a1) + Math.log(size);
    }

    public double getGenomeAbundance() {
        return this.genomeAbundance;
    }

    public double getGenomeLength() {
        return this.genomeLength;
    }

    public int getLowLimit() {
        return this.lowLimit;
    }

    public void setLowLimit(int lowLimit) {
        this.lowLimit = lowLimit;
    }

    public int getHighLimit() {
        return this.highLimit;
    }

    public void setHighLimit(int highLimit) {
        this.highLimit = highLimit;
    }
}

