% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BSRInference-class.R,
%   R/BSRInferenceComp-class.R
\name{rescoreInference}
\alias{rescoreInference}
\alias{rescoreInference,BSRInference-method}
\alias{rescoreInference,BSRInferenceComp-method}
\title{Inference re-scoring}
\usage{
\S4method{rescoreInference}{BSRInference}(
  obj,
  param,
  rank.p = 0.55,
  fdr.proc = c("BH", "Bonferroni", "Holm", "Hochberg", "SidakSS", "SidakSD", "BY", "ABH",
    "TSBH")
)

\S4method{rescoreInference}{BSRInferenceComp}(
  obj,
  param = NULL,
  rank.p = 0.55,
  fdr.proc = c("BH", "Bonferroni", "Holm", "Hochberg", "SidakSS", "SidakSD", "BY", "ABH",
    "TSBH")
)
}
\arguments{
\item{obj}{BSRInferecenceComp object.}

\item{param}{NULL by default}

\item{rank.p}{A number between 0 and 1 defining the rank of the last
considered target genes.}

\item{fdr.proc}{The procedure for adjusting P-values according to
\code{\link[multtest]{mt.rawp2adjp}}.}
}
\value{
A BSRInference object.

A BSRInferenceComp object.
}
\description{
A method to re-score an existing BSRInference object
(P- and Q-value estimations).

A method to re-score an existing BSRInferenceComp object
(P- and Q-value estimations).
}
\details{
A BSRInference object should be created by calling
\code{"\link[=BSRDataModel-class]{BSRInference}"}

Parameters controlling the estimation
of the statistical significance of the ligand/receptor/pathway triples
(\code{param}) are provided at the time of calling the latter method.

Nonetheless, it
might be useful to change the initially-provided parameters, in
which case this method should not be called.

A BSRInferenceComp object should be created by calling
\code{"\link[=BSRInferenceComp-class]{BSRInferenceComp}"}
}
\examples{
data(bsrinf, package = "BulkSignalR")
data(bsrdm, package = "BulkSignalR")

bsrinf.new <- rescoreInference(bsrinf,
                  param = parameters(bsrdm)
              )
data(bsrinf.comp, package = "BulkSignalR")

bsrinf.less <- rescoreInference(bsrinf.comp, 
rank.p = 0.75)
}
