% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BSRClusterComp-class.R
\name{BSRClusterComp}
\alias{BSRClusterComp}
\title{Definition of the comparison between two clusters of samples}
\usage{
BSRClusterComp(obj, col.clusterA, col.clusterB, differential.stats)
}
\arguments{
\item{obj}{A BSRDataModelComp object.}

\item{col.clusterA}{Cluster A column indices.}

\item{col.clusterB}{Cluster B column indices.}

\item{differential.stats}{A data.frame containing statistics about
the differential
analysis cluster A versus B. \code{differentialStats} must contain 
at least the
columns 'pval' (for P-values), 'logFC' for log-fold-changes A/B, and
'expr' for the expression of the genes in cluster A.}
}
\value{
A BSRClusterComp object.
}
\description{
Define the columns of the expression matrix that belong to each cluster,
and store the result of the cluster differences statistical analysis
obtained by an external tool such as edgeR or DESeq2 in a dedicated
data frame.
}
\details{
Create a BSRClusterComp object describing a comparison
of two clusters of columns taken from the expression matrix
in the BSRDataModelComp object \code{obj}. Such a cluster comparison
description is the basis for inferring LRIs from differential
expression P-values instead of correlation analysis.

The rows of \code{differentialStats} must be in the same order 
as those of the count
matrix in \code{obj}. Alternatively, \code{differentialStats}
rows can be named and a 1-1 correspondence must exist between these names
and those of the count matrix.
}
\examples{
# prepare data
data(sdc, package = "BulkSignalR")
normal <- grep("^N", names(sdc))
bsrdm <- BSRDataModel(sdc[, -normal])

# define the comparison
bsrdm.comp <- as(bsrdm, "BSRDataModelComp")
colA <- as.integer(1:3)
colB <- as.integer(12:15)
n <- nrow(ncounts(bsrdm.comp))
stats <- data.frame(
    pval = runif(n), logFC = rnorm(n, 0, 2),
    expr = runif(n, 0, 10)
)
rownames(stats) <- rownames(ncounts(bsrdm.comp))
bsrcc <- BSRClusterComp(bsrdm.comp, colA, colB, stats)

}
