% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inference.R
\name{.pValuesLR}
\alias{.pValuesLR}
\title{Internal function to assign P-values to LR interactions}
\usage{
.pValuesLR(
  pairs,
  param,
  rank.p = 0.75,
  fdr.proc = c("BH", "Bonferroni", "Holm", "Hochberg", "SidakSS", "SidakSD", "BY", "ABH",
    "TSBH")
)
}
\arguments{
\item{pairs}{A data frame output by \code{checkReceptorSignaling}.}

\item{param}{A list containing the statistical model parameters.}

\item{rank.p}{A number between 0 and 1 defining the rank of the last
considered target genes.}

\item{fdr.proc}{The procedure for adjusting P-values according to
\code{\link[multtest]{mt.rawp2adjp}}.}
}
\value{
A data.frame with the data in \code{pairs} complemented with
P-values and adjusted P-values.
}
\description{
Estimate the P-value of each ligand-receptor pair based
on the data frame output by \code{\link{.checkReceptorSignaling}}.
}
\keyword{internal}
