% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cemitool.R
\name{expr_data}
\alias{expr_data}
\alias{expr_data,CEMiTool-method}
\alias{expr_data<-}
\alias{expr_data<-,CEMiTool-method}
\title{Retrieve and set expression attribute}
\usage{
expr_data(cem, ...)

\S4method{expr_data}{CEMiTool}(cem, filter = TRUE, apply_vst = FALSE, filter_pval = 0.1, ...)

expr_data(cem) <- value

\S4method{expr_data}{CEMiTool}(cem) <- value
}
\arguments{
\item{cem}{Object of class \code{CEMiTool}}

\item{...}{Additional parameters to \code{filter_genes} or
\code{select_genes} functions.}

\item{filter}{logical. If TRUE, retrieves filtered expression data (Default: TRUE)}

\item{apply_vst}{logical. If TRUE, applies variance stabilizing transformation to
expression data (Default: FALSE)}

\item{filter_pval}{logical. Threshold for filter p-value. Ignored if
filter = FALSE (Default: 0.1)}

\item{value}{Object of class \code{data.frame} with gene
expression data}
}
\value{
Object of class \code{data.frame} with gene expression data
}
\description{
Retrieve and set expression attribute
}
\examples{
# Initialize an empty CEMiTool object
cem <- new_cem()
# Get example expression data
data(expr0)
# Add expression file to CEMiTool object
expr_data(cem) <- expr0
# Check expression file
head(expr_data(cem))
}
