% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modules.R
\name{get_hubs}
\alias{get_hubs}
\alias{get_hubs,CEMiTool-method}
\title{Get hubs}
\usage{
get_hubs(cem, ...)

\S4method{get_hubs}{CEMiTool}(cem, n = 5, method = "adjacency")
}
\arguments{
\item{cem}{Object of class \code{CEMiTool}.}

\item{...}{Optional parameters.}

\item{n}{Number of hubs to return from each module. If "all", returns all genes
in decreasing order of connectivity. Default: 5.}

\item{method}{Method for hub calculation. Either "adjacency" or "kME".
Default: "adjacency"}
}
\value{
A \code{list} containing hub genes for each module and the value of
the calculated method.
}
\description{
Returns \code{n} genes in each module with high connectivity.
}
\examples{
# Get example CEMiTool object
data(cem)
# Get module hubs
hubs <- get_hubs(cem, n=10, "adjacency")

}
