<img src="inst/www/emm_logo.png" align="right" alt="" width="120" />

# ExploreModelMatrix
[![Codecov.io coverage status](https://codecov.io/github/csoneson/ExploreModelMatrix/coverage.svg?branch=master)](https://codecov.io/github/csoneson/ExploreModelMatrix)
[![R build status](https://github.com/csoneson/ExploreModelMatrix/workflows/R-CMD-check/badge.svg)](https://github.com/csoneson/ExploreModelMatrix/actions)

`ExploreModelMatrix` is a small R package that lets the user interactively
explore a design matrix as generated by the `model.matrix()` R function. 
In particular, given a table with sample information
and a design formula, `ExploreModelMatrix` illustrates the fitted values 
from a general linear model (or, more generally, the value of the linear 
predictor of a generalized linear model) for each combination of
input variables, simplifying understanding and generation of contrasts. A 
number of other visualizations are also included in the interactive interface, 
particularly simplifying the interpretation of linear models. 

![](https://github.com/csoneson/ExploreModelMatrix/blob/master/inst/www/ExploreModelMatrix.jpg?raw=true)

## Installation

You can install `ExploreModelMatrix` from Bioconductor (note that you need 
at least release 3.11 of Bioconductor, released in April 2020):

```
if (!requireNamespace("BiocManager", quietly = TRUE))
    install.packages("BiocManager")
BiocManager::install("ExploreModelMatrix")
```

## Usage

The main function in the `ExploreModelMatrix` package is called
`ExploreModelMatrix()`. When calling `ExploreModelMatrix()`, simply provide a
_data.frame_ (or _DataFrame_) with sample information and a design formula:

```
sampleData <- data.frame(genotype = rep(c("A", "B"), each = 4),
                         treatment = rep(c("ctrl", "trt"), 4))
ExploreModelMatrix(sampleData = sampleData,
                   designFormula = ~ genotype + treatment)
```

This will open up an [R/Shiny](https://shiny.rstudio.com/) application where you
can explore the specified design matrix and the fitted values for each
combination of predictor values.

For more examples of designs, we refer to the package vignette. 
