% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculateVIFs.R
\name{.CalculateVIFsLM}
\alias{.CalculateVIFsLM}
\title{Calculate variance inflation factors from a design matrix}
\usage{
.CalculateVIFsLM(mm)
}
\arguments{
\item{mm}{A model.matrix object}
}
\value{
A data.frame with estimated VIFs for each coefficient, or NULL if the
  calculations could not be performed (there are no non-intercept columns in
  the design matrix, or the linear model fitting fails).
}
\description{
The calculation of VIFs is done by fitting a linear model for each column in
the design matrix, with all the other columns (except the intercept) as
predictors. If there is an intercept (a column named "(Intercept)") in the
original design matrix, each linear model will be fit with an intercept. If
there is no such column in the original design matrix, the linear models will
be fit without an intercept. After fitting the linear model for column i, the
corresponding VIF is calculated as 1/(1-R^2), where R^2 is the coefficient of
determination of the model. "Inf" results (obtained when R^2=1) are replaced
by NAs.
}
\author{
Charlotte Soneson
}
\keyword{internal}
