% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filterSmallChromosomes.R
\name{filterSmallChromosomes}
\alias{filterSmallChromosomes}
\title{Filter small chromosomes.}
\usage{
filterSmallChromosomes(object, threshold = NULL)
}
\arguments{
\item{object}{A \code{\link{HiCDOCDataSet}}.}

\item{threshold}{The minimum length (number of positions) for a chromosome to be kept.
Defaults to \code{object$smallChromosomeThreshold} which is originally set to
\code{defaultHiCDOCParameters$smallChromosomeThreshold} = 100.}
}
\value{
A filtered \code{\link{HiCDOCDataSet}}.
}
\description{
Removes chromosomes whose length (in number of positions) is smaller than the
threshold.
}
\examples{
data(exampleHiCDOCDataSet)
object <- exampleHiCDOCDataSet

chromosomes(object)
object <- filterSmallChromosomes(object)
chromosomes(object)

}
\seealso{
\code{\link{filterSparseReplicates}},
\code{\link{filterWeakPositions}},
\code{\link{HiCDOC}}
}
