% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotConcordances.R
\name{plotConcordances}
\alias{plotConcordances}
\title{Plot concordances.}
\usage{
plotConcordances(
  object,
  chromosome,
  xlim = NULL,
  threshold = 0.05,
  points = FALSE
)
}
\arguments{
\item{object}{A \code{\link{HiCDOCDataSet}}.}

\item{chromosome}{A chromosome name or index in \code{chromosomes(object)}.}

\item{xlim}{A vector of the minimum and maximum positions to display. If NULL, displays
all positions. Defaults to NULL.}

\item{threshold}{Significance threshold for the compartment changes. Defaults to 0.05.}

\item{points}{Whether or not to add points to the concordances. Defaults to FALSE.}
}
\value{
A \code{ggplot}.
}
\description{
Plots the concordances of each replicate in each experiment condition. A
concordance can be understood as a confidence in a genomic position's
assigned compartment. Mathematically, it is the log ratio of a genomic
position's distance to each compartment's centroid, normalized by the
distance between both centroids, and min-maxed to a [-1,1] interval.
}
\examples{
data(exampleHiCDOCDataSetProcessed)
plotConcordances(exampleHiCDOCDataSetProcessed, chromosome = 1)

}
