% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotConcordanceDifferences.R
\name{plotConcordanceDifferences}
\alias{plotConcordanceDifferences}
\title{Plot the distribution of concordance differences.}
\usage{
plotConcordanceDifferences(object)
}
\arguments{
\item{object}{A \code{\link{HiCDOCDataSet}}.}
}
\value{
A \code{ggplot}.
}
\description{
Plots the distribution of concordance differences, which are the differences
between concordances of each pair of replicates from different conditions. A
concordance can be understood as a confidence in a genomic position's
assigned compartment. Mathematically, it is the log ratio of a genomic
position's distance to each compartment's centroid, normalized by the
distance between both centroids, and min-maxed to a [-1,1] interval.
}
\examples{
data(exampleHiCDOCDataSetProcessed)
plotConcordanceDifferences(exampleHiCDOCDataSetProcessed)

}
