% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reduceDataSet.R
\name{reduceHiCDOCDataSet}
\alias{reduceHiCDOCDataSet}
\title{Reduce a \code{\link{HiCDOCDataSet}}.}
\usage{
reduceHiCDOCDataSet(
  object,
  chromosomes = NULL,
  conditions = NULL,
  replicates = NULL,
  dropLevels = TRUE
)
}
\arguments{
\item{object}{A \code{\link{HiCDOCDataSet}}.}

\item{chromosomes}{The chromosome names or indices in \code{chromosomes(object)} to keep.
Defaults to NULL.}

\item{conditions}{The condition names in \code{sampleConditions(object)} to keep. 
Defaults to NULL.}

\item{replicates}{The replicate names in \code{sampleReplicates(object)} to keep. 
Defaults to NULL.}

\item{dropLevels}{Whether or not to also remove unused factor levels after filtering. Should
be set to FALSE if the reduced objects are meant to be re-combined later.
Defaults to TRUE.}
}
\value{
A reduced \code{\link{HiCDOCDataSet}}.
}
\description{
Reduces a \code{\link{HiCDOCDataSet}} by keeping only given chromosomes,
conditions, or replicates.
}
\examples{
data(exampleHiCDOCDataSet)
reduced <- reduceHiCDOCDataSet(exampleHiCDOCDataSet, chromosomes = c(1, 2))

}
