% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{gseaPlot}
\alias{gseaPlot}
\title{Create a GSEA plot that displays the running enrichment score (ES) for a
given pathway}
\usage{
gseaPlot(
  enrichment,
  pathway,
  showTitle = TRUE,
  rankingMetric = FALSE,
  lineColor = "green",
  lineSize = 1,
  vlineColor = "red",
  vlineSize = 0.6
)
}
\arguments{
\item{enrichment}{An object of class
\code{\link[=FunctionalEnrichment-class]{FunctionalEnrichment}} containing
enrichment results}

\item{pathway}{It must be the name of a significantly enriched term/pathway
for which we want to produce a GSEA plot (e.g. 'Thyroid hormone synthesis')}

\item{showTitle}{Logical, whether to add the name of the pathway/term as
plot title. Default is TRUE}

\item{rankingMetric}{Logical, whether to show the variations of the ranking
metric below the plot. Default is FALSE}

\item{lineColor}{It must be an R color name that specifies the color of
the running score line. Default is \code{green}. Available color formats include
color names, such as 'blue' and 'red', and hexadecimal colors specified
as #RRGGBB}

\item{lineSize}{The line width of the running score line. Default is \code{1}}

\item{vlineColor}{It must be an R color name that specifies the color of
the vertical line indicating the enrichment score (ES). Default is \code{red}.
Available color formats include color names, such as 'blue' and 'red', and
hexadecimal colors specified as #RRGGBB}

\item{vlineSize}{The line width of the vertical line indicating the
enrichment score (ES). Default is \code{0.6}}
}
\value{
An object of class \code{ggplot} containing the GSEA plot.
}
\description{
This function creates a classic enrichment plot to show the results of
gene set enrichment analyses (GSEA). In particular, this function takes as
input GSEA results originating from the \code{\link[=enrichGenes]{enrichGenes()}} function, and
returns a \link{ggplot2} object with GSEA plot. In this kind of plots, the
running enrichment score (ES) for a given pathway is shown on the y-axis,
whereas gene positions in the ranked list are reported on the x-axis.
}
\examples{
# load example FunctionalEnrichment object
obj <- loadExamples("FunctionalEnrichment")

# plot results
gseaPlot(obj, pathway = "Thyroid hormone synthesis")

}
\author{
Jacopo Ronchi, \email{jacopo.ronchi@unimib.it}
}
