% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R
\name{integration}
\alias{integration}
\title{Explore the results of the integration analysis between miRNAs and genes}
\usage{
integration(object, param = FALSE)
}
\arguments{
\item{object}{A \code{\link[=MirnaExperiment-class]{MirnaExperiment}} object containing
miRNA and gene data}

\item{param}{Logical, whether to return the complete \code{list} object with
the parameters used, or just the results stored in \code{data}. Default is FALSE}
}
\value{
If \code{param} is FALSE, then this functions returns a \code{data.frame} object
containing the results of the integration analysis. Otherwise, a \code{list}
object including the parameters used for the analysis will be returned.
}
\description{
After performing the integration analysis between miRNA and gene expression
values with the \code{\link[=mirnaIntegration]{mirnaIntegration()}} function, the results are stored
in the \code{integration} slot of a
\code{\link[=MirnaExperiment-class]{MirnaExperiment}} object and can be explored with
this function.
}
\examples{
# load example MirnaExperiment object
obj <- loadExamples()

# visualize the results of correlation analysis
res <- integration(obj)
res

}
\author{
Jacopo Ronchi, \email{jacopo.ronchi@unimib.it}
}
