% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CreateTabulaReport.R
\name{multiPathwayModuleReport}
\alias{multiPathwayModuleReport}
\title{Provides a Table of the Modules Test Results}
\usage{
multiPathwayModuleReport(multiPathwayModuleList, priority_to = NULL)
}
\arguments{
\item{multiPathwayModuleList}{a list of \code{MultiOmicsModules} objects
resulting from a multi-omics module test.}

\item{priority_to}{a vector with the covariates (the omics names)
that should appear first in the dataframe columns}
}
\value{
a data.frame class object. Rows correspond to the modules, and the
columns to the overall and covariates pvalues of the test.
}
\description{
Summarizes the results of a multi omics module test given a list of
MultiOmicsModules objects
}
\examples{
data(multiOmics)
data(reactSmall)

genesToUse <- row.names(multiOmics[[1]])

MOM_list <- lapply(reactSmall[1:2], function(g) {
    fcl <- multiOmicsSurvivalModuleTest(multiOmics, g,
        survFormula = "Surv(days, status) ~",
        autoCompleteFormula = TRUE,
        useTheseGenes = genesToUse
    )
    fcl
})

moduleSummary <- multiPathwayModuleReport(MOM_list)

}
