% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/locatePTM.R
\name{locatePTM}
\alias{locatePTM}
\title{Annotate modified sites with associated peptides}
\usage{
locatePTM(peptide, uniprot, fasta, modResidue, modSymbol, rmConfound = FALSE)
}
\arguments{
\item{peptide}{A string vector of peptide sequences. The peptide sequence
does not include its preceding and following AAs.}

\item{uniprot}{A string vector of Uniprot identifiers of the peptides'
originating proteins. UniProtKB entry isoform sequence is used.}

\item{fasta}{A tibble with FASTA information. Output of \code{tidyFasta}.}

\item{modResidue}{A string. Modifiable amino acid residues.}

\item{modSymbol}{A string. Symbol of a modified site.}

\item{rmConfound}{A logical. \code{TRUE} removes confounded
unmodified sites, \code{FALSE} otherwise. Default is \code{FALSE}.}
}
\value{
A data frame with three columns: \code{uniprot_iso}, \code{peptide},
\code{site}.
}
\description{
\code{PTMlocate} annotates modified sites with associated peptides.
}
\examples{
fasta <- tidyFasta(system.file("extdata", "O13297.fasta", package="MSstatsLiP"))
locatePTM("DRVSYIHNDSC*TR", "O13297", fasta, "C", "\\\\*")

}
