% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_directory_config.R
\name{config_file}
\alias{config_file}
\title{Get path for ORFik config in cache}
\usage{
config_file(
  cache = BiocFileCache::getBFCOption("CACHE"),
  query = "ORFik_config",
  ask = interactive(),
  old_config_location = "~/Bio_data/ORFik_config.csv"
)
}
\arguments{
\item{cache}{path to bioc cache directory with rname from query argument.
Default is: \code{BiocFileCache::getBFCOption("CACHE")}
For info, see: [BiocFileCache::BiocFileCache()]}

\item{query}{default: "ORFik_config". Exact rname of the file in cache.}

\item{ask}{logical, default interactive().}

\item{old_config_location}{path, old config location before BiocFileCache
implementation.
Will copy this to cache directory and delete old version.
This is done to follow bioc rules on not writing to user home directory.}
}
\value{
a file path in cache
}
\description{
Get path for ORFik config in cache
}
\examples{
config_file()
# Another config path
config_file(query = "ORFik_config_2")

}
