% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_exports.R
\name{export.ofst,GAlignmentPairs-method}
\alias{export.ofst,GAlignmentPairs-method}
\title{Store GRanges / GAlignments object as .ofst}
\usage{
\S4method{export.ofst}{GAlignmentPairs}(x, file, ...)
}
\arguments{
\item{x}{a GRanges, GAlignments or GAlignmentPairs object}

\item{file}{a character, location on disc (full path)}

\item{...}{additional arguments for write_fst}
}
\value{
NULL, object saved to disc
}
\description{
A much faster way to store, load and use bam files.\cr
.ofst is ORFik fast serialized object,
an optimized format for coverage reads with
cigar and replicate number. It uses the fst format as back-end:
\code{\link{fst-package}}.\cr A .ofst ribo seq file can compress the
information in a bam file from 5GB down to a few MB. This new files has
super fast reading time, only a few seconds, instead of minutes. It also has
random index access possibility of the file. \cr
.ofst is represented as a data.frane format with minimum 4 columns:\cr
1. chromosome\cr  2. start (left most position) \cr 3. strand (+, -, *)\cr
4. width (not added if cigar exists)\cr
5. cigar (not needed if width exists):
 (cigar # M's, match/mismatch total) \cr
5. score: duplicates of that read\cr
6. size: qwidth according to reference of read\cr\cr
If file is from GAlignmentPairs, it will contain a cigar1, cigar2 instead
of cigar and start1 and start2 instead of start
}
\details{
Other columns can be named whatever you want and added to meta columns.
Positions are 1-based, not 0-based as .bed.
Import with import.ofst
}
\examples{
## GRanges
gr <- GRanges("1:1-3:-")
# export.ofst(gr, file = "path.ofst")
## GAlignment
# Make input data.frame
df <- data.frame(seqnames = "1", cigar = "3M", start = 1L, strand = "+")
ga <- ORFik:::getGAlignments(df)
# export.ofst(ga, file = "path.ofst")
}
