% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ranges_helpers.R
\name{pmapFromTranscriptF}
\alias{pmapFromTranscriptF}
\title{Faster pmapFromTranscript}
\usage{
pmapFromTranscriptF(x, transcripts, removeEmpty = FALSE)
}
\arguments{
\item{x}{IRangesList/IRanges/GRanges to map to genomic coordinates}

\item{transcripts}{a GRangesList to map against (the genomic coordinates)}

\item{removeEmpty}{a logical, remove non hit exons, else they are set
to 0. That is all exons in the reference that the transcript coordinates
do not span.}
}
\value{
a GRangesList of mapped reads, names from ranges are kept.
}
\description{
Map range coordinates between features in the transcriptome and
genome (reference) space.
The length of x must be the same as length of transcripts. Only exception is
if x have integer names like (1, 3, 3, 5), so that x[1] maps to 1, x[2] maps
to transcript 3 etc.
}
\details{
This version tries to fix the short commings of GenomicFeature's version.
Much faster and uses less memory.
Implemented as dynamic program optimized c++ code.
}
\examples{
ranges <- IRanges(start = c( 5, 6), end = c(10, 10))
seqnames = rep("chr1", 2)
strands = rep("-", 2)
grl <- split(GRanges(seqnames, IRanges(c(85, 70), c(89, 82)), strands),
             c(1, 1))
ranges <- split(ranges, c(1,1)) # both should be mapped to transcript 1
pmapFromTranscriptF(ranges, grl, TRUE)

}
