% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/STAR.R
\name{STAR.remove.crashed.genome}
\alias{STAR.remove.crashed.genome}
\title{Remove crashed STAR genome}
\usage{
STAR.remove.crashed.genome(index.path, star.path = STAR.install())
}
\arguments{
\item{index.path}{path to index folder of genome}

\item{star.path}{path to STAR, default: STAR.install(),
if you don't have STAR installed at default location, it will install it there,
set path to a runnable star if you already have it.}
}
\value{
return value from system call, 0 if all good.
}
\description{
This happens if you abort STAR run early, and it halts at: ..... loading genome
}
\examples{
index.path = "/home/data/human_GRCh38/STAR_INDEX/genomeDir/"
# STAR.remove.crashed.genome(index.path = index.path)
## If you have the index argument from STAR.index function:
# index.path <- STAR.index()
# STAR.remove.crashed.genome(file.path(index.path, "genomeDir"))
# STAR.remove.crashed.genome(file.path(index.path, "contaminants_genomeDir"))
}
\seealso{
Other STAR: 
\code{\link{STAR.align.folder}()},
\code{\link{STAR.align.single}()},
\code{\link{STAR.allsteps.multiQC}()},
\code{\link{STAR.index}()},
\code{\link{STAR.install}()},
\code{\link{STAR.multiQC}()},
\code{\link{getGenomeAndAnnotation}()},
\code{\link{install.fastp}()}
}
\concept{STAR}
