% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/experiment.R
\name{bamVarName}
\alias{bamVarName}
\title{Get library variable names from ORFik \code{\link{experiment}}}
\usage{
bamVarName(
  df,
  skip.replicate = length(unique(df$rep)) == 1,
  skip.condition = length(unique(df$condition)) == 1,
  skip.stage = length(unique(df$stage)) == 1,
  skip.fraction = length(unique(df$fraction)) == 1,
  skip.experiment = !tryCatch(df@expInVarName, error = function(e) FALSE),
  skip.libtype = FALSE,
  fraction_prepend_f = TRUE
)
}
\arguments{
\item{df}{an ORFik \code{\link{experiment}}}

\item{skip.replicate}{a logical (FALSE), don't include replicate
in variable name.}

\item{skip.condition}{a logical (FALSE), don't include condition
in variable name.}

\item{skip.stage}{a logical (FALSE), don't include stage
in variable name.}

\item{skip.fraction}{a logical (FALSE), don't include fraction}

\item{skip.experiment}{a logical (FALSE), don't include experiment}

\item{skip.libtype}{a logical (FALSE), don't include libtype}

\item{fraction_prepend_f}{a logical (TRUE), include "f" in front of
fraction, useful for knowing what fraction is.}
}
\value{
variable names of libraries (character vector)
}
\description{
What will each sample be called given the columns of the experiment?
A column is included if more than 1 unique element value exist in that column.
}
\examples{
df <- ORFik.template.experiment()
bamVarName(df)

## without libtype
bamVarName(df, skip.libtype = TRUE)
## Without experiment name
bamVarName(df, skip.experiment = TRUE)
}
\seealso{
Other ORFik_experiment: 
\code{\link{ORFik.template.experiment}()},
\code{\link{ORFik.template.experiment.zf}()},
\code{\link{create.experiment}()},
\code{\link{experiment-class}},
\code{\link{filepath}()},
\code{\link{libraryTypes}()},
\code{\link{organism,experiment-method}},
\code{\link{outputLibs}()},
\code{\link{read.experiment}()},
\code{\link{save.experiment}()},
\code{\link{validateExperiments}()}
}
\concept{ORFik_experiment}
