% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_collapse.R
\name{collapseDuplicatedReads,data.table-method}
\alias{collapseDuplicatedReads,data.table-method}
\title{Collapse duplicated reads}
\usage{
\S4method{collapseDuplicatedReads}{data.table}(
  x,
  addScoreColumn = TRUE,
  addSizeColumn = FALSE,
  reuse.score.column = TRUE,
  keepCigar = FALSE
)
}
\arguments{
\item{x}{a GRanges, GAlignments or GAlignmentPairs object}

\item{addScoreColumn}{logical, default: (TRUE), if FALSE,
only collapse and not keep score column of counts for collapsed reads.
Returns directly without collapsing if reuse.score.column is FALSE and
score is already defined.}

\item{addSizeColumn}{logical (FALSE), if TRUE, add a size column that
for each read, that gives original width of read. Useful if you need
original read lengths. This takes care of soft clips etc.
If collapsing reads, each unique range will be grouped also by size.}

\item{reuse.score.column}{logical (TRUE), if addScoreColumn is TRUE,
and a score column exists, will sum up the scores to create a new score.
If FALSE, will skip old score column and create new according to number
of replicated reads after conversion.
If addScoreColumn is FALSE, this argument is ignored.}

\item{keepCigar}{logical, default FALSE. Keep the cigar information}
}
\value{
a GRanges, GAlignments, GAlignmentPairs or data.table object,
 same as input
}
\description{
For every GRanges, GAlignments read, with the same:
seqname, start, (cigar) / width and strand, collapse and give a new
meta column called "score", which contains the number of duplicates
of that read. If score column already exists, will return input object!
}
\examples{
gr <- rep(GRanges("chr1", 1:10,"+"), 2)
collapseDuplicatedReads(gr)
}
