% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_directory_config.R
\name{config.exper}
\alias{config.exper}
\title{Set directories for experiment}
\usage{
config.exper(
  experiment,
  assembly,
  type,
  config = ORFik::config(),
  sub_dir_single = file.path(type, experiment, ""),
  name_with_type_suffix = TRUE
)
}
\arguments{
\item{experiment}{short name of experiment (must be valid as a folder name)}

\item{assembly}{name of organism and assembly (must be valid as a folder name)}

\item{type}{name of sequencing type, Ribo-seq, RNA-seq, CAGE.. Can be more than
one.}

\item{config}{a named character vector of length 3,
default: \code{ORFik::config()}}

\item{sub_dir_single}{character, path. Default: \code{file.path(type, experiment, "")}
The subdirectory relative to config defined main locations. If defined location
should be used directly without making subdirectories, set to "".}

\item{name_with_type_suffix}{logical, default TRUE. Make fastq name
like 'fastq RNA-seq', setting it to FALSE gives name 'fastq'. Only allowed
when length(type) == 1}
}
\value{
named character vector of paths for experiment
}
\description{
Defines a folder for:
1. fastq files (raw_data)\cr
2. bam files (processed data)\cr
3. references (organism annotation and STAR index)\cr
4. Experiment (name of experiment)
}
\examples{
# Where should files go in general?
ORFik::config()
# Paths for project: "Alexaki_Human" containing Ribo-seq and RNA-seq:
#config.exper("Alexaki_Human", "Homo_sapiens_GRCh38_101", c("Ribo-seq", "RNA-seq"))
}
