% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_format_conversion.R
\name{convert_to_covRle}
\alias{convert_to_covRle}
\title{Convert libraries to covRle}
\usage{
convert_to_covRle(
  df,
  in_files = filepath(df, "pshifted"),
  out_dir = file.path(libFolder(df), "cov_RLE"),
  split.by.strand = TRUE,
  split.by.readlength = FALSE,
  seq_info = seqinfo(df),
  weight = "score",
  format = "qs",
  verbose = TRUE
)
}
\arguments{
\item{df}{an ORFik \code{\link{experiment}}, or NULL is allowed if
both in_files and out_dir is specified manually.}

\item{in_files}{paths to input files, default pshifted files:
\code{filepath(df, "pshifted")} in ofst format}

\item{out_dir}{paths to output files, default
\code{file.path(libFolder(df), "cov_RLE")}.}

\item{split.by.strand}{logical, default TRUE, split into forward and reverse
strand RleList inside covRle object.}

\item{split.by.readlength}{logical, default FALSE, split into files
for each readlength, defined by readWidths(x) for each file.}

\item{seq_info}{SeqInfo object, default \code{seqinfo(findFa(df))}}

\item{weight}{integer, numeric or single length character. Default "score".
Use score column in loaded in_files.}

\item{format}{chatacter, default "qs", alternative "rds". File format to
save R object.}

\item{verbose}{logical, default TRUE, message about library output status.}
}
\value{
invisible(NULL), files saved to disc
}
\description{
Saved by default in folder "cov_RLE" relative to default
libraries of experiment
}
\examples{
df <- ORFik.template.experiment()[10,]
## Usually do default folder, here we use tmpdir
folder_to_save <- file.path(tempdir(), "cov_RLE")
convert_to_covRle(df, out_dir = folder_to_save)
fimport(file.path(folder_to_save, "RFP_Mutant_rep2.covqs"))
}
\seealso{
Other lib_converters: 
\code{\link{convertLibs}()},
\code{\link{convert_bam_to_ofst}()},
\code{\link{convert_to_bigWig}()},
\code{\link{convert_to_covRleList}()}
}
\concept{lib_converters}
