% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_exports.R
\name{export.wiggle}
\alias{export.wiggle}
\title{Export as wiggle format}
\usage{
export.wiggle(x, file)
}
\arguments{
\item{x}{A GRangesList, GAlignment GAlignmentPairs with score column.
Will be converted to 5' end position of original range. If score column
does not exist, will group ranges and give replicates as score column.}

\item{file}{a character path to valid output file name}
}
\value{
invisible(NULL) (File is saved as 2 .wig files)
}
\description{
Will create 2 files, 1 for + strand (*_forward.wig)
and 1 for - strand (*_reverse.wig). If all
ranges are * stranded, will output 1 file.
Can be direct input for ucsc browser or IGV
}
\examples{
x <- c(GRanges("1", c(1,3,5), "-"), GRanges("1", c(1,3,5), "+"))
# export.wiggle(x, "output/path/rna.wig")
}
\references{
https://genome.ucsc.edu/goldenPath/help/wiggle.html
}
\seealso{
Other utils: 
\code{\link{bedToGR}()},
\code{\link{convertToOneBasedRanges}()},
\code{\link{export.bed12}()},
\code{\link{export.bigWig}()},
\code{\link{export.fstwig}()},
\code{\link{fimport}()},
\code{\link{findFa}()},
\code{\link{fread.bed}()},
\code{\link{optimizeReads}()},
\code{\link{readBam}()},
\code{\link{readBigWig}()},
\code{\link{readWig}()}
}
\concept{utils}
