% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grl_extend.R
\name{extendLeadersUntil}
\alias{extendLeadersUntil}
\title{Extend Leaders Until}
\usage{
extendLeadersUntil(
  grl,
  grl2 = grl,
  extension = 500,
  until = 200,
  min_ext = 25,
  is.circular = all(isCircular(grl) \%in\% TRUE),
  ...
)
}
\arguments{
\item{grl}{a GRangesList}

\item{grl2}{a GRangesList, default 'grl'. The list that defines
restrictions on extension. Can also be another set, which is
used as 'roadblocks' for extension.}

\item{extension}{an integer, how much to max extend upstream (5' end).
Either single value that will apply for all, or same as length of grl
which will give 1 update value per grl object.
Or a GRangesList where start / stops by strand are the positions
to use as new starts.
Will not cross the chromosome boundary for non circular chromosomes.}

\item{until}{numeric, default 200. The nearest you can go to the neighbour
boundaries of grl2 (the "other" genes).
Defined as boundary hit + 1, so if hit other gene with distance 22, and
'until' argument is 2, will set final extension to 22-2-1 = 19.
Usually if Leaders/trailers are not defined,
this makes a good pseudo leader boundary around your other genes.}

\item{min_ext}{numeric, default 25. What is the minimum extension, even though it crosses a boundary.
Will not cross the chromosome boundary for non circular chromosomes.}

\item{is.circular}{logical, default FALSE if not any is: all(isCircular(grl) %in% TRUE).
Where grl is the ranges checked. If TRUE, allow ranges to extend
below position 1 on chromosome. Since circular genomes can have negative coordinates.}

\item{...}{Arguments sent to distanceToPreceding}
}
\value{
a GRangesList of extended grl input
}
\description{
Extend leaders until a restriction group / position. This makes you extend until
you hit another gene boundary etc.
}
\examples{
grl <- GRangesList(tx1 = GRanges("1", IRanges(c(10, 15), c(13, 20)), "+"),
                   tx2 = GRanges("1", IRanges(30, 50), "+"))
extendLeadersUntil(grl, min_ext = 5)
extendLeadersUntil(grl, min_ext = 5, until = 1)
extendLeadersUntil(grl, min_ext = 5, until = 1)
extendLeadersUntil(grl, min_ext = 5, until = 1, extension = 4)
}
