% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/intercell_curated.R
\name{curated_ligrec_stats}
\alias{curated_ligrec_stats}
\title{Statistics about literature curated ligand-receptor interactions}
\usage{
curated_ligrec_stats(...)
}
\arguments{
\item{...}{Passed to \code{\link{curated_ligand_receptor_interactions}},
determines the set of all curated L-R interactions which will be
compared against each of the individual resources.}
}
\value{
A data frame with estimated counts of curated ligand-receptor
    interactions for each L-R resource.
}
\description{
Statistics about literature curated ligand-receptor interactions
}
\details{
The data frame contains the total number of interactions, the number
of interactions which overlap with the set of curated interactions
\emph{(curated_overlap),} the number of interactions with literature
references from the given resource \emph{(literature)} and the number
of interactions which are curated by the given resource
\emph{(curated_self)}. This latter we defined according to our best
knowledge, in many cases it's not possible to distinguish curated
interactions). All these numbers are also presented as a percent of
the total. Importantly, here we consider interactions curated only if
they've been curated in a cell-cell communication context.
}
\examples{
clr <- curated_ligrec_stats()
clr

}
\seealso{
\code{\link{curated_ligand_receptor_interactions}}
}
