% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nichenet.R
\name{nichenet_signaling_network}
\alias{nichenet_signaling_network}
\title{Builds a NicheNet signaling network}
\usage{
nichenet_signaling_network(
  omnipath = list(),
  pathwaycommons = list(),
  harmonizome = list(),
  vinayagam = list(),
  cpdb = list(),
  evex = list(),
  inbiomap = list(),
  only_omnipath = FALSE
)
}
\arguments{
\item{omnipath}{List with paramaters to be passed to
\code{\link{nichenet_signaling_network_omnipath}}.}

\item{pathwaycommons}{List with paramaters to be passed to
\code{\link{nichenet_signaling_network_pathwaycommons}}.}

\item{harmonizome}{List with paramaters to be passed to
\code{\link{nichenet_signaling_network_harmonizome}}.}

\item{vinayagam}{List with paramaters to be passed to
\code{\link{nichenet_signaling_network_vinayagam}}.}

\item{cpdb}{List with paramaters to be passed to
\code{\link{nichenet_signaling_network_cpdb}}.}

\item{evex}{List with paramaters to be passed to
\code{\link{nichenet_signaling_network_evex}}.}

\item{inbiomap}{List with paramaters to be passed to
\code{\link{nichenet_signaling_network_inbiomap}}.}

\item{only_omnipath}{Logical: a shortcut to use only OmniPath as network
resource.}
}
\value{
A network data frame (tibble) with signaling interactions
    suitable for use with NicheNet.
}
\description{
Builds signaling network prior knowledge for NicheNet using multiple
resources.
}
\examples{
# load everything with the default parameters:
# we don't load inBio Map due to the - hopefully
# temporary - issues of their server
sig_network <- nichenet_signaling_network(inbiomap = NULL, cpdb = NULL)

# override parameters for some resources:
sig_network <- nichenet_signaling_network(
    omnipath = list(resources = c('SIGNOR', 'SignaLink3', 'SPIKE')),
    pathwaycommons = NULL,
    harmonizome = list(datasets = c('phosphositeplus', 'depod')),
    # we can not include this in everyday tests as it takes too long:
    # cpdb = list(complex_max_size = 1, min_score = .98),
    cpdb = NULL,
    evex = list(min_confidence = 1.5),
    inbiomap = NULL
)

# use only OmniPath:
sig_network_omnipath <- nichenet_signaling_network(only_omnipath = TRUE)

}
\seealso{
\itemize{
    \item{\code{\link{nichenet_signaling_network_omnipath}}}
    \item{\code{\link{nichenet_signaling_network_pathwaycommons}}}
    \item{\code{\link{nichenet_signaling_network_harmonizome}}}
    \item{\code{\link{nichenet_signaling_network_vinayagam}}}
    \item{\code{\link{nichenet_signaling_network_cpdb}}}
    \item{\code{\link{nichenet_signaling_network_evex}}}
    \item{\code{\link{nichenet_signaling_network_inbiomap}}}
}
}
