## ----pipe, include=FALSE------------------------------------------------------------------------------------
`%>%` <- magrittr::`%>%`

## ----show---------------------------------------------------------------------------------------------------
library(OmnipathR)
omnipath_show_db()

## ----get----------------------------------------------------------------------------------------------------
up_gs <- get_db('up_gs')
up_gs

## ----show-2-------------------------------------------------------------------------------------------------
omnipath_show_db()

## ----show-3-------------------------------------------------------------------------------------------------
d <- omnipath_show_db()
d %>% dplyr::pull(db) %>% magrittr::extract2(16)
d %>% dplyr::pull(latest_param) %>% magrittr::extract2(16)

## ----sleep, include=FALSE-----------------------------------------------------------------------------------
# some sleep time to make sure we see a time difference
Sys.sleep(10)

## ----expiry-------------------------------------------------------------------------------------------------
up_gs <- get_db('up_gs')
omnipath_show_db()

## ----env----------------------------------------------------------------------------------------------------
OmnipathR:::omnipathr.env$db$up_gs

## ----lifetime, eval=FALSE-----------------------------------------------------------------------------------
# options(omnipath.db_lifetime = 600)
# omnipath_save_config()

## ----session------------------------------------------------------------------------------------------------
sessionInfo()

