% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annotate_network.R
\name{annotated_network}
\alias{annotated_network}
\title{Network interactions with annotations}
\usage{
annotated_network(
  network = NULL,
  annot = NULL,
  network_args = list(),
  annot_args = list(),
  ...
)
}
\arguments{
\item{network}{Behaviour depends on type: if list, will be passed as
arguments to \code{\link{omnipath_interactions}} to obtain a
network data frame; if a data frame or tibble, it will be used as a
network data frame; if a character vector, will be assumed to be a
set of resource names and interactions will be queried from these
resources.}

\item{annot}{Either the name of an annotation resource (for a list of
available resources call \code{\link{annotation_resources}}), or
an annotation data frame. If the data frame contains more than one
resources, only the first one will be used.}

\item{network_args}{List: if `network` is a resource name, pass these
additional arguments to \code{\link{omnipath_interactions}}.}

\item{annot_args}{List: if `annot` is a resource name, pass these
additional arguments to \code{\link{annotations}}.}

\item{...}{Column names selected from the annotation data frame (passed
to \code{dplyr::select}, if empty all columns will be selected.)}
}
\value{
A data frame of interactions with annotations for both interacting
    entities.
}
\description{
Annotations are often useful in a network context, e.g. one might want to
label the interacting partners by their pathway membership. This function
takes a network data frame and joins an annotation data frame from both
the left and the right side, so both the source and target molecular
entities will be labeled by their annotations. If one entity has many
annotations these will yield many rows, hence the interacting pairs won't
be unique across the data frame any more. Also if one entity has really
many annotations the resulting data frame might be huge, we recommend to
be careful with that. Finally, if you want to do the same but with
intercell annotations, there is the \code{\link{import_intercell_network}}
function.
}
\examples{
signalink_with_pathways <-
    annotated_network("SignaLink3", "SignaLink_pathway")

}
