% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bioplex.R
\name{bioplex_all}
\alias{bioplex_all}
\title{Downloads all BioPlex interaction datasets}
\usage{
bioplex_all(unique = TRUE)
}
\arguments{
\item{unique}{Logical. Collapse the duplicate interactions into single
rows or keep them as they are. In case of merging duplicate records
the maximum p value will be choosen for each record.}
}
\value{
Data frame (tibble) with interactions.
}
\description{
BioPlex provides four interaction datasets: version 1.0, 2.0, 3.0 and
HCT116 version 1.0. This function downloads all of them, merges them to
one data frame, removes the duplicates (based on unique pairs of UniProt
IDs) and separates the isoform numbers from the UniProt IDs.
More details at \url{https://bioplex.hms.harvard.edu/interactions.php}.
}
\examples{
bioplex_interactions <- bioplex_all()
bioplex_interactions
# # A tibble: 195,538 x 11
#    UniprotA IsoformA UniprotB IsoformB GeneA GeneB SymbolA SymbolB
#    <chr>       <int> <chr>       <int> <dbl> <dbl> <chr>   <chr>
#  1 A0AV02          2 Q5K4L6         NA 84561 11000 SLC12A8 SLC27A3
#  2 A0AV02          2 Q8N5V2         NA 84561 25791 SLC12A8 NGEF
#  3 A0AV02          2 Q9H6S3         NA 84561 64787 SLC12A8 EPS8L2
#  4 A0AV96          2 O00425          2 54502 10643 RBM47   IGF2BP3
#  5 A0AV96          2 O00443         NA 54502  5286 RBM47   PIK3C2A
#  6 A0AV96          2 O43426         NA 54502  8867 RBM47   SYNJ1
#  7 A0AV96          2 O75127         NA 54502 26024 RBM47   PTCD1
#  8 A0AV96          2 O95208          2 54502 22905 RBM47   EPN2
#  9 A0AV96          2 O95900         NA 54502 26995 RBM47   TRUB2
# 10 A0AV96          2 P07910          2 54502  3183 RBM47   HNRNPC
# # . with 195,528 more rows, and 3 more variables: p_wrong <dbl>,
# #   p_no_interaction <dbl>, p_interaction <dbl>

}
\seealso{
\itemize{
    \item{\code{\link{bioplex1}}}
    \item{\code{\link{bioplex2}}}
    \item{\code{\link{bioplex3}}}
    \item{\code{\link{bioplex_hct116_1}}}
}
}
