% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evex.R
\name{evex_download}
\alias{evex_download}
\title{Interactions from the EVEX database}
\usage{
evex_download(
    min_confidence = NULL,
    remove_negatives = TRUE,
    top_confidence = NULL
)
}
\arguments{
\item{min_confidence}{Numeric: a threshold for confidence scores. EVEX
confidence scores span roughly from -3 to 3. By providing a numeric
value in this range the lower confidence interactions can be removed.
If NULL no filtering performed.}

\item{remove_negatives}{Logical: remove the records with the "negation"
attribute set.}

\item{top_confidence}{Confidence cutoff as quantile (a number between
0 and 1). If NULL no filtering performed.}
}
\value{
Data frame (tibble) with interactions.
}
\description{
Downloads interactions from EVEX, a versatile text mining resource
(\url{http://evexdb.org}). Translates the Entrez Gene IDs to Gene Symbols
and combines the interactions and references into a single data frame.
}
\examples{
evex_interactions <- evex_download()
evex_interactions
# # A tibble: 368,297 x 13
#   general_event_id source_entrezge. target_entrezge. confidence negation
#               <dbl> <chr>            <chr>                 <dbl>    <dbl>
# 1               98 8651             6774                 -1.45         0
# 2              100 8431             6774                 -1.45         0
# 3              205 6261             6263                  0.370        0
# 4              435 1044             1045                 -1.09         0
# . with 368,287 more rows, and 8 more variables: speculation <dbl>,
#   coarse_type <chr>, coarse_polarity <chr>, refined_type <chr>,
#   refined_polarity <chr>, source_genesymbol <chr>,
#   target_genesymbol <chr>, references <chr>
}
