% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph.R
\name{find_all_paths}
\alias{find_all_paths}
\title{All paths between two groups of vertices}
\usage{
find_all_paths(
    graph,
    start,
    end,
    attr = NULL,
    mode = 'OUT',
    maxlen = 2,
    progress = TRUE
)
}
\arguments{
\item{graph}{An igraph graph object.}

\item{start}{Integer or character vector with the indices or names
of one or more start vertices.}

\item{end}{Integer or character vector with the indices or names
of one or more end vertices.}

\item{attr}{Character: name of the vertex attribute to identify the
vertices by. Necessary if `start` and `end` are not igraph vertex ids
but for example vertex names or labels.}

\item{mode}{Character: IN, OUT or ALL. Default is OUT.}

\item{maxlen}{Integer: maximum length of paths in steps, i.e. if
maxlen = 3, then the longest path may consist of 3 edges and 4 nodes.}

\item{progress}{Logical: show a progress bar.}
}
\value{
List of vertex paths, each path is a character or integer vector.
}
\description{
Finds all paths up to length `maxlen` between specified groups of
vertices. This function is needed only becaues igraph`s
`all_shortest_paths` finds only the shortest, not any
path up to a defined length.
}
\examples{
interactions <- import_omnipath_interactions()
graph <- interaction_graph(interactions)
paths <- find_all_paths(
    graph = graph,
    start = c('EGFR', 'STAT3'),
    end = c('AKT1', 'ULK1'),
    attr = 'name'
)

}
\seealso{
\itemize{
    \item{\code{\link{interaction_graph}}}
    \item{\code{\link{enzsub_graph}}}
    \item{\code{\link{giant_component}}}
}
}
