% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/id_mapping.R
\name{hmdb_id_mapping_table}
\alias{hmdb_id_mapping_table}
\title{Identifier translation table from HMDB}
\usage{
hmdb_id_mapping_table(to, from, entity_type = "metabolite")
}
\arguments{
\item{to}{Character or symbol: target ID type. See Details for possible
values.}

\item{from}{Character or symbol: source ID type. See Details for possible
values.}

\item{entity_type}{Character: "gene" and "smol" are short symbols for
proteins, genes and small molecules respectively. Several other synonyms
are also accepted.}
}
\value{
A data frame (tibble) with columns `From` and `To`.
}
\description{
Identifier translation table from HMDB
}
\details{
The arguments \code{to} and \code{from} can be provided either
as character or as symbol (NSE). Their possible values are either HMDB XML
tag names or synonyms listed at \code{\link{id_types}}.
}
\examples{
hmdb_kegg <- hmdb_id_mapping_table("kegg", "hmdb")
hmdb_kegg

}
\seealso{
\itemize{
    \item{\code{\link{translate_ids}}}
    \item{\code{\link{id_types}}}
    \item{\code{\link{hmdb_table}}}
    \item{\code{\link{uniprot_full_id_mapping_table}}}
    \item{\code{\link{uniprot_id_mapping_table}}}
    \item{\code{\link{ensembl_id_mapping_table}}}
    \item{\code{\link{chalmers_gem_id_mapping_table}}}
}
}
