% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kegg.R
\name{kegg_pathway_download}
\alias{kegg_pathway_download}
\title{Download one KEGG pathway}
\usage{
kegg_pathway_download(
  pathway_id,
  process = TRUE,
  max_expansion = NULL,
  simplify = FALSE
)
}
\arguments{
\item{pathway_id}{Character: a KEGG pathway identifier, for example
"hsa04350".}

\item{process}{Logical: process the data or return it in raw format.
processing means joining the entries and relations into a single
data frame and adding UniProt IDs.}

\item{max_expansion}{Numeric: the maximum number of relations
derived from a single relation record. As one entry might represent
more than one molecular entities, one relation might yield a large
number of relations in the processing. This happens in a combinatorial
way, e.g. if the two entries represent 3 and 4 entities, that results
12 relations. If \code{NULL}, all relations will be expanded.}

\item{simplify}{Logical: remove KEGG's internal identifiers and the
pathway annotations, keep only unique interactions with direction
and effect sign.}
}
\value{
A data frame (tibble) of interactions if \code{process} is
    \code{TRUE}, otherwise a list with two data frames: "entries" is
    a raw table of the entries while "relations" is a table of relations
    extracted from the KGML file.
}
\description{
Downloads one pathway diagram from the KEGG Pathways database in KGML
format and processes the XML to extract the interactions.
}
\examples{
tgf_pathway <- kegg_pathway_download('hsa04350')
tgf_pathway
# # A tibble: 50 x 12
#    source target type  effect arrow relation_id kegg_id_source
#    <chr>  <chr>  <chr> <chr>  <chr> <chr>       <chr>
#  1 51     49     PPrel activ. -->   hsa04350:1  hsa:7040 hsa:.
#  2 57     55     PPrel activ. -->   hsa04350:2  hsa:151449 hs.
#  3 34     32     PPrel activ. -->   hsa04350:3  hsa:3624 hsa:.
#  4 20     17     PPrel activ. -->   hsa04350:4  hsa:4838
#  5 60     46     PPrel activ. -->   hsa04350:5  hsa:4086 hsa:.
# # . with 45 more rows, and 5 more variables: genesymbol_source <chr>,
# #   uniprot_source <chr>, kegg_id_target <chr>,
# #   genesymbol_target <chr>, uniprot_target <chr>

}
\seealso{
\itemize{
    \item{\code{\link{kegg_process}}}
    \item{\code{\link{kegg_pathways_download}}}
    \item{\code{\link{kegg_pathway_list}}}
}
}
